#include <ultra64.h>
#include "sm64.h"
#include "behavior_data.h"
#include "model_ids.h"
#include "seq_ids.h"
#include "dialog_ids.h"
#include "segment_symbols.h"
#include "level_commands.h"
#include "game/level_update.h"
#include "levels/scripts.h"
#include "actors/common1.h"
#include "make_const_nonconst.h"

#include "areas/1/custom.model.inc.h"

#include "levels/ttm/header.h"
#include "levels/rr/header.h"

extern u8 _ttm_segment_ESegmentRomStart[];
extern u8 _ttm_segment_ESegmentRomEnd[];

const LevelScript level_ttm_entry[] = {
INIT_LEVEL(),
LOAD_MIO0(0x07, _rr_segment_7SegmentRomStart, _rr_segment_7SegmentRomEnd),
LOAD_RAW(0x1A, _rrSegmentRomStart, _rrSegmentRomEnd),
LOAD_RAW(0x0E, _ttm_segment_ESegmentRomStart, _ttm_segment_ESegmentRomEnd),
LOAD_MIO0(0xA, _SkyboxCustom24221632_skybox_mio0SegmentRomStart, _SkyboxCustom24221632_skybox_mio0SegmentRomEnd),
LOAD_MIO0(8, _common0_mio0SegmentRomStart, _common0_mio0SegmentRomEnd),
LOAD_RAW(15, _common0_geoSegmentRomStart, _common0_geoSegmentRomEnd),
LOAD_MIO0(5, _group9_mio0SegmentRomStart, _group9_mio0SegmentRomEnd),
LOAD_RAW(12, _group9_geoSegmentRomStart, _group9_geoSegmentRomEnd),
LOAD_MIO0(6, _group14_mio0SegmentRomStart, _group14_mio0SegmentRomEnd),
LOAD_RAW(13, _group14_geoSegmentRomStart, _group14_geoSegmentRomEnd),
ALLOC_LEVEL_POOL(),
MARIO(/*model*/ MODEL_MARIO, /*behParam*/ 0x00000001, /*beh*/ bhvMario),
// Level Specific Models
LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_03,           rr_geo_000660),
LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_04,           rr_geo_000678),
LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_05,           rr_geo_000690),
LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_06,           rr_geo_0006A8),
LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_07,           rr_geo_0006C0),
LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_08,           rr_geo_0006D8),
LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_09,           rr_geo_0006F0),
LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_0A,           rr_geo_000708),
LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_0B,           rr_geo_000720),
LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_0C,           rr_geo_000738),
LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_0D,           rr_geo_000758),
LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_0E,           rr_geo_000770),
LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_0F,           rr_geo_000788),
LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_10,           rr_geo_0007A0),
LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_11,           rr_geo_0007B8),
LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_12,           rr_geo_0007D0),
LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_13,           rr_geo_0007E8),
LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_14,           rr_geo_000800),
LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_15,           rr_geo_000818),
LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_16,           rr_geo_000830),
LOAD_MODEL_FROM_GEO(MODEL_RR_SLIDING_PLATFORM,         rr_geo_0008C0),
LOAD_MODEL_FROM_GEO(MODEL_RR_FLYING_CARPET,            rr_geo_000848),
LOAD_MODEL_FROM_GEO(MODEL_RR_OCTAGONAL_PLATFORM,       rr_geo_0008A8),
LOAD_MODEL_FROM_GEO(MODEL_RR_ROTATING_BRIDGE_PLATFORM, rr_geo_000878),
LOAD_MODEL_FROM_GEO(MODEL_RR_TRIANGLE_PLATFORM,        rr_geo_0008D8),
LOAD_MODEL_FROM_GEO(MODEL_RR_CRUISER_WING,             rr_geo_000890),
LOAD_MODEL_FROM_GEO(MODEL_RR_SEESAW_PLATFORM,          rr_geo_000908),
LOAD_MODEL_FROM_GEO(MODEL_RR_L_SHAPED_PLATFORM,        rr_geo_000940),
LOAD_MODEL_FROM_GEO(MODEL_RR_SWINGING_PLATFORM,        rr_geo_000860),
LOAD_MODEL_FROM_GEO(MODEL_RR_DONUT_PLATFORM,           rr_geo_000920),
LOAD_MODEL_FROM_GEO(MODEL_RR_ELEVATOR_PLATFORM,        rr_geo_0008F0),
LOAD_MODEL_FROM_GEO(MODEL_RR_TRICKY_TRIANGLES,         rr_geo_000958),
LOAD_MODEL_FROM_GEO(MODEL_RR_TRICKY_TRIANGLES_FRAME1,  rr_geo_000970),
LOAD_MODEL_FROM_GEO(MODEL_RR_TRICKY_TRIANGLES_FRAME2,  rr_geo_000988),
LOAD_MODEL_FROM_GEO(MODEL_RR_TRICKY_TRIANGLES_FRAME3,  rr_geo_0009A0),
LOAD_MODEL_FROM_GEO(MODEL_RR_TRICKY_TRIANGLES_FRAME4,  rr_geo_0009B8),
// Unspecified Models
LOAD_MODEL_FROM_GEO(22,  warp_pipe_geo),
LOAD_MODEL_FROM_GEO(23,  bubbly_tree_geo),
LOAD_MODEL_FROM_GEO(24,  spiky_tree_geo),
LOAD_MODEL_FROM_GEO(25,  snow_tree_geo),
LOAD_MODEL_FROM_GEO(27,  palm_tree_geo),
LOAD_MODEL_FROM_GEO(31,  metal_door_geo),
LOAD_MODEL_FROM_GEO(32,  hazy_maze_door_geo),
LOAD_MODEL_FROM_GEO(34,  castle_door_0_star_geo),
LOAD_MODEL_FROM_GEO(35,  castle_door_1_star_geo),
LOAD_MODEL_FROM_GEO(36,  castle_door_3_stars_geo),
LOAD_MODEL_FROM_GEO(37,  key_door_geo),
LOAD_MODEL_FROM_GEO(38,  castle_door_geo),
// LOAD_MODEL_FROM_DL(132, 0x08025f08, 4),
// LOAD_MODEL_FROM_DL(158, 0x0302c8a0, 4),
// LOAD_MODEL_FROM_DL(159, 0x0302bcd0, 4),
// LOAD_MODEL_FROM_DL(161, 0x0301cb00, 4),
// LOAD_MODEL_FROM_DL(164, 0x04032a18, 4),
// LOAD_MODEL_FROM_DL(201, 0x080048e0, 4),
// LOAD_MODEL_FROM_DL(218, 0x08024bb8, 4),
JUMP_LINK(script_func_global_1),
JUMP_LINK(script_func_global_10),
JUMP_LINK(script_func_global_15),
JUMP_LINK(local_area_ttm_1_),
FREE_LEVEL_POOL(),
MARIO_POS(/* area */ 1, /* yaw */ 0, /* pos */ 0, 0, 0),
CALL(/*arg*/ 0, /*func*/ lvl_init_or_update),
CALL_LOOP(/*arg*/ 1, /*func*/ lvl_init_or_update),
CLEAR_LEVEL(),
SLEEP_BEFORE_EXIT(/*frames*/ 1),
EXIT(),
};

const LevelScript local_area_ttm_1_[] = {
AREA(1, Geo_ttm_1_0x173f6d0),
TERRAIN(col_ttm_1_0xe0bcdf0),
SET_BACKGROUND_MUSIC(0, 48),
TERRAIN_TYPE(0),
JUMP_LINK(local_objects_ttm_1_),
JUMP_LINK(local_warps_ttm_1_),
END_AREA(),
RETURN()
};

const LevelScript local_objects_ttm_1_[] = {
OBJECT_WITH_ACTS(0, 243, 1274, -5421, 0, 0, 0, 0xa0000,  bhvSpinAirborneWarp, 31),
OBJECT_WITH_ACTS(137, 5558, -200, -1136, 0, 0, 0, 0x0,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(201, -447, -347, 2258, 0, 169, 0, 0xc00000,  bhvCannonClosed, 31),
OBJECT_WITH_ACTS(122, -300, 2750, 0, 0, 0, 0, 0x0,  bhvStar, 31),
OBJECT_WITH_ACTS(0, -4787, 1000, -2695, 0, 0, 0, 0x1000000,  bhvHiddenRedCoinStar, 31),
OBJECT_WITH_ACTS(122, -5025, 2250, 5025, 0, 0, 0, 0x2000000,  bhvStar, 31),
OBJECT_WITH_ACTS(84, 3150, 2550, 5431, 0, 0, 0, 0x3000000,  bhvBalconyBigBoo, 31),
OBJECT_WITH_ACTS(122, 243, 3096, -5421, 0, 0, 0, 0x5000000,  bhvStar, 31),
OBJECT_WITH_ACTS(14, 243, 3096, -5421, 0, 0, 0, 0x0,  bhvStaticObject, 31),
OBJECT_WITH_ACTS(0, 3400, 2300, 5431, 0, 0, 0, 0x960000,  bhvPoleGrabbing, 31),
OBJECT_WITH_ACTS(215, -4627, 1844, -966, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -4249, 1494, -1014, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -5406, 1794, -955, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -5817, 1494, -1014, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -4918, 999, -1026, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -4409, 1249, -514, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -5373, 1199, -546, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -4923, 1544, -234, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(0, 3400, 2300, 5431, 0, 0, 0, 0x20000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, -5025, 3198, 5025, 0, 0, 0, 0x20000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, -2061, -650, 1368, 0, 0, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 4600, -393, -5350, 0, 0, 0, 0x140000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 4000, -1098, 5900, 0, 0, 0, 0x120000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, -3187, 480, -4482, 0, 0, 0, 0x0,  bhvGoombaTripletSpawner, 31),
OBJECT_WITH_ACTS(0, 3507, -383, -320, 0, 0, 0, 0x0,  bhvGoombaTripletSpawner, 31),
OBJECT_WITH_ACTS(14, 4631, -444, -4771, 0, 0, 0, 0x0,  bhvStaticObject, 31),
OBJECT_WITH_ACTS(14, 4011, -1148, 5266, 0, 0, 0, 0x0,  bhvStaticObject, 31),
OBJECT_WITH_ACTS(220, 741, 57, -3085, 0, 0, 0, 0x0,  bhvFlyGuy, 31),
OBJECT_WITH_ACTS(220, -4016, 1400, -666, 0, 0, 0, 0x0,  bhvFlyGuy, 31),
OBJECT_WITH_ACTS(220, -5739, 2040, -604, 0, 0, 0, 0x0,  bhvFlyGuy, 31),
OBJECT_WITH_ACTS(220, -2143, 664, -5705, 0, 0, 0, 0x0,  bhvFlyGuy, 31),
OBJECT_WITH_ACTS(220, -5622, 1850, 2740, 0, 0, 0, 0x0,  bhvFlyGuy, 31),
OBJECT_WITH_ACTS(192, -4268, 750, -2575, 0, 0, 0, 0x0,  bhvGoomba, 31),
OBJECT_WITH_ACTS(192, -5341, 750, -2880, 0, 0, 0, 0x0,  bhvGoomba, 31),
OBJECT_WITH_ACTS(195, -1534, -700, 1458, 0, 0, 0, 0x0,  bhvBobombBuddyOpensCannon, 31),
OBJECT_WITH_ACTS(0, -3414, 1300, 3315, 0, 0, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(207, -1065, 0, 0, 0, 0, 0, 0x0,  bhvFloorSwitchHiddenObjects, 31),
OBJECT_WITH_ACTS(129, -353, 350, 412, 0, 60, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, -180, 350, 512, 0, 60, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, 180, 750, 512, 0, 120, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, 353, 750, 412, 0, 120, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, 533, 1150, 100, 0, 180, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, 533, 1150, -100, 0, 180, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, 353, 1550, -412, 0, 60, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, 180, 1550, -512, 0, 60, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, -180, 1950, -512, 0, 120, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, -353, 1950, -412, 0, 120, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(192, -217, 0, -1094, 0, 0, 0, 0x0,  bhvGoomba, 31),
OBJECT_WITH_ACTS(192, 1171, 0, 395, 0, 0, 0, 0x0,  bhvGoomba, 31),
OBJECT_WITH_ACTS(192, -847, 0, 797, 0, 0, 0, 0x0,  bhvGoomba, 31),
OBJECT_WITH_ACTS(140, -5053, 1550, 2903, 0, 0, 0, 0x0,  bhvBlueCoinSwitch, 31),
OBJECT_WITH_ACTS(118, -5217, 2100, 4042, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, -4479, 2100, 4209, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, -4062, 2100, 4834, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, -4209, 2100, 5571, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, -4834, 2100, 5988, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, -5571, 2100, 5842, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, -5988, 2100, 5217, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, -5842, 2100, 4479, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(220, 623, 1300, 413, 0, 0, 0, 0x0,  bhvFlyGuy, 31),
OBJECT_WITH_ACTS(220, 5795, -150, -806, 0, 0, 0, 0x0,  bhvFlyGuy, 31),
OBJECT_WITH_ACTS(187, 31, 75, 1079, 0, 0, 0, 0x0,  bhvButterfly, 31),
OBJECT_WITH_ACTS(187, 466, 75, 932, 0, 0, 0, 0x0,  bhvButterfly, 31),
OBJECT_WITH_ACTS(187, -984, 75, 244, 0, 0, 0, 0x0,  bhvButterfly, 31),
OBJECT_WITH_ACTS(187, -928, 75, -490, 0, 0, 0, 0x0,  bhvButterfly, 31),
OBJECT_WITH_ACTS(187, 831, 75, -433, 0, 0, 0, 0x0,  bhvButterfly, 31),
OBJECT_WITH_ACTS(187, 505, 75, -770, 0, 0, 0, 0x0,  bhvButterfly, 31),
OBJECT_WITH_ACTS(187, -2058, -650, 1342, 0, 0, 0, 0x0,  bhvTripletButterfly, 31),
OBJECT_WITH_ACTS(187, 1513, -425, -1740, 0, 0, 0, 0x0,  bhvButterfly, 31),
OBJECT_WITH_ACTS(187, 520, 325, -5338, 0, 0, 0, 0x0,  bhvButterfly, 31),
OBJECT_WITH_ACTS(187, 34, 325, -5598, 0, 0, 0, 0x0,  bhvButterfly, 31),
OBJECT_WITH_ACTS(187, 5640, -375, -1030, 0, 0, 0, 0x0,  bhvButterfly, 31),
OBJECT_WITH_ACTS(187, 5460, -375, -1208, 0, 0, 0, 0x0,  bhvButterfly, 31),
OBJECT_WITH_ACTS(187, -4604, 825, -2208, 0, 0, 0, 0x0,  bhvButterfly, 31),
OBJECT_WITH_ACTS(187, -4944, 825, -2189, 0, 0, 0, 0x0,  bhvButterfly, 31),
OBJECT_WITH_ACTS(187, -4257, 825, -2956, 0, 0, 0, 0x0,  bhvButterfly, 31),
OBJECT_WITH_ACTS(187, -4412, 825, -3272, 0, 0, 0, 0x0,  bhvButterfly, 31),
OBJECT_WITH_ACTS(187, -5345, 825, -3089, 0, 0, 0, 0x0,  bhvButterfly, 31),
OBJECT_WITH_ACTS(187, -3386, 1325, 3463, 0, 0, 0, 0x0,  bhvButterfly, 31),
OBJECT_WITH_ACTS(187, -3481, 1325, 3156, 0, 0, 0, 0x0,  bhvButterfly, 31),
OBJECT_WITH_ACTS(187, -4886, 1625, 2899, 0, 0, 0, 0x0,  bhvButterfly, 31),
OBJECT_WITH_ACTS(187, -5301, 1625, 2922, 0, 0, 0, 0x0,  bhvButterfly, 31),
OBJECT_WITH_ACTS(187, -4132, 2125, 5380, 0, 0, 0, 0x0,  bhvButterfly, 31),
OBJECT_WITH_ACTS(187, -4369, 2125, 5789, 0, 0, 0, 0x0,  bhvButterfly, 31),
OBJECT_WITH_ACTS(187, -5766, 2125, 5702, 0, 0, 0, 0x0,  bhvButterfly, 31),
OBJECT_WITH_ACTS(187, -5332, 2125, 5909, 0, 0, 0, 0x0,  bhvButterfly, 31),
OBJECT_WITH_ACTS(187, -4880, 2125, 5928, 0, 0, 0, 0x0,  bhvTripletButterfly, 31),
OBJECT_WITH_ACTS(192, -4165, 2050, 4456, 0, 0, 0, 0x0,  bhvGoomba, 31),
OBJECT_WITH_ACTS(192, -5098, 2050, 5941, 0, 0, 0, 0x0,  bhvGoomba, 31),
OBJECT_WITH_ACTS(192, -6108, 2050, 4522, 0, 0, 0, 0x0,  bhvGoomba, 31),
OBJECT_WITH_ACTS(180, 1600, 2800, 5431, 0, 0, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(180, 4901, 2800, 5431, 0, 0, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(180, 3150, 2800, 4806, 0, 0, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(180, 3150, 2800, 6056, 0, 0, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(212, 6400, 2862, 5431, 0, 0, 0, 0x0,  bhv1Up, 31),
OBJECT_WITH_ACTS(212, 4360, 812, -287, 0, 0, 0, 0x0,  bhv1Up, 31),
OBJECT_WITH_ACTS(0, 3504, -333, -289, 0, 0, 0, 0x120000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, -3171, 530, -4481, 0, 0, 0, 0x120000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(137, 4895, -193, -5804, 0, 0, 0, 0x0,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(137, 3746, -898, 6367, 0, 0, 0, 0x0,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(124, -50, 250, -5000, 0, 150, 0, 0xa90000,  bhvMessagePanel, 31),
OBJECT_WITH_ACTS(212, 0, 3500, 0, 0, 0, 0, 0x0,  bhv1Up, 31),
OBJECT_WITH_ACTS(0, 20, 5, 1330, 0, 0, 20, 4,  RM_Scroll_Texture, 31),
RETURN()
};

const LevelScript local_warps_ttm_1_[] = {
WARP_NODE(10, 9, 1, 0, 0),
WARP_NODE(240, 6, 3, 42, 0),
WARP_NODE(241, 6, 3, 52, 0),
RETURN()
};
